/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PlayerAdvancements.class})
public class PlayerAdvancementTrackerMixin {
    @Shadow
    private ServerPlayerEntity field_192762_j;

    @Inject(method={"grantCriterion"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancement/PlayerAdvancementTracker;endTrackingCompleted(Lnet/minecraft/advancement/Advancement;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void checkOriginUpgrade(Advancement advancement, String criterionName, CallbackInfoReturnable<Boolean> info, boolean bl, AdvancementProgress advancementProgress, boolean bl2) {
        if (advancementProgress.func_192105_a()) {
            Origin.get((PlayerEntity)this.field_192762_j).forEach((layer, o) -> {
                Optional<OriginUpgrade> upgrade = o.getUpgrade(advancement);
                if (upgrade.isPresent()) {
                    try {
                        Origin upgradeTo = OriginRegistry.get(upgrade.get().getUpgradeToOrigin());
                        if (upgradeTo != null) {
                            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)this.field_192762_j);
                            component.setOrigin((OriginLayer)layer, upgradeTo);
                            component.sync();
                            String announcement = upgrade.get().getAnnouncement();
                            if (!announcement.isEmpty()) {
                                this.field_192762_j.func_146105_b((ITextComponent)new TranslationTextComponent(announcement).func_240699_a_(TextFormatting.GOLD), false);
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.error("Could not perform Origins upgrade from " + o.getIdentifier().toString() + " to " + upgrade.get().getUpgradeToOrigin().toString() + ", as the upgrade origin did not exist!");
                    }
                }
            });
        }
    }
}

